<?php declare(strict_types=1);
if (!defined('MW_PATH')) {
    exit('No direct script access allowed');
}

/**
 * Html purifier configuration file
 *
 * Please do not edit this file in any way.
 * Create common/config/htmlpurifier-custom.php and it will be merged with this file.
 *
 * @package MailWizz EMA
 * @author MailWizz Development Team <support@mailwizz.com>
 * @link https://www.mailwizz.com/
 * @copyright MailWizz EMA (https://www.mailwizz.com)
 * @license https://www.mailwizz.com/license/
 * @since 1.0
 */

return [

    // core related
    'Core.Encoding'             => app()->charset,
    'Core.EscapeInvalidTags'    => false,

    // uri related
    'URI.Base'              => null,
    'URI.AllowedSchemes'    => [
        'http'      => true,
        'https'     => true,
        'mailto'    => true,
        'ftp'       => true,
        'ftps'      => true,
        'nntp'      => true,
        'news'      => true,
        'tel'       => true,
        'callto'    => true,
        'data'      => true,
        '['         => true, // pretty weird this works...
    ],
    'URI.SafeIframeRegexp' => '%^(http:|https:)?//(www.youtube(?:-nocookie)?.com/embed/|player.vimeo.com/video/)%',

    // html related
    'HTML.Trusted'              => true, // keep en eye on this
    'HTML.ForbiddenElements'    => ['script'],
    'HTML.ForbiddenAttributes'  => ['on*'],
    'HTML.SafeIframe'           => true,
    'HTML.MaxImgLength'         => null,
    'HTML.DefinitionID'         => 'html-definitions',
    'HTML.DefinitionRev'        => 31, // increment this when the init class is changed

    // attributes
    'Attr.EnableID'             => true,
    'Attr.AllowedRel'           => ['noindex', 'nofollow'],
    'Attr.AllowedFrameTargets'  => ['_blank', '_self', '_parent', '_top'],

    // css
    'CSS.AllowTricky'      => true,
    'CSS.AllowImportant'   => true,
    'CSS.Proprietary'      => true,
    'CSS.Trusted'          => true, // keep en eye on this
    'CSS.MaxImgLength'     => null,
];
