
## Table of Content
* [Single personalization](#example1)
* [Single personalization with two recipient big token](#example2)
* [Two personalization](#example3)
* [Multiple personalization](#example4)
* [Without attachment check scheduling](#example5)
* [Multiple to](#example6)
* [Multiple cc](#example7)

<a name="example1"></a>
## Single personalization

```php
<?php

require_once "vendor/autoload.php";

use PepipostLib\Models;
use PepipostLib\Exceptions;

$apiKey = 'your api_key here';

$client = new PepipostLib\PepipostClient($apiKey);

$mailSendController = $client->getMailSend();

$body = new Models\Send;
$body->from = new Models\From;
$body->from->email = 'hello@your-register-domain-with-pepipost';
$body->from->name = 'Example Pepi';
$body->subject = 'schedulett1 [%NAME%] [%SURNAME%] [%PROFESSION%] [%AREA%]';
$body->templateId = 22299;
$body->content = array();

$body->content[0] = new Models\Content;
$body->content[0]->type = Models\TypeEnum::HTML;
$body->content[0]->value = '<html><body><p>This Avail FREEBIEES 1. [%NAME%] 2. [%SURNAME%] 3. [% PROFESSION %] 4. [%AREA%] Thishis</p><a href=\'https://uatdeveloper.yesbank.in/ibm_apim/activate/x?activationToken=eyJ1cmwiOiJodHRwczovLzEwLjAuNDAuMTc4L3YxL3BvcnRhbC91c2Vycy81YzMwNjZmOGU0YjBmZThmNjgwMTMyYzkvYWN0aXZhdGUiLCJ1c2VybmFtZSI6IiFCQVNFNjRfU0lWX0VOQyFfQWJURXBibHNMdzBsR3NXb2dJRXNZV2pwTnhFQmRpVXljRzdyQXMyZ1dkMS9BQUFBSEd4TldHYXdadGZXTXBMY3dZR3YrUE13elNGZkJyTUlhN0g1T1dGUGNtZDciLCJhdXRoZW50aWNhdGlvbiI6eyJ1c2VybmFtZSI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMi81NWUwMjQzMWU0YjA4MGZjMzM5ZDk5OTgvTjRnSzNwQjZsUjBsTzRySDRoWDhjQjFhWDZ3TTdnQzhzTjR1VTJxVzdkIiwicGFzc3dvcmQiOiJUZmRic0VoWjd6MXQxQjZhSG02cWxCRXlxWnhiL2ZZbkVNYUNaMjNMZDQifSwicHJvdmlkZXJDb250ZXh0Ijp7Im9yZ0lEIjoiNTVlMDI0MzBlNGIwODBmYzMzOWQ5OTkyIiwiZW52aXJvbm1lbnRJRCI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMiJ9fQ\'>Click Here</a><br><p>This is link 2</p><a href=\'https://www.amazon.com/ap/signin?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fcard%3Fie%3DUTF8%26ref_%3Dcust_rec_intestitial_signin\'>Click Here</a><p>This is link 3</p><a href=\'http://gadgets.ndtv.com/\'>Click Here</a><br></body></html>';

$body->attachments = array();

$body->attachments[0] = new Models\Attachments;
$body->attachments[0]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->attachments[0]->name = 'tesxt2.txt';

$body->personalizations = array();

$body->personalizations[0] = new Models\Personalizations;
$body->personalizations[0]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test1","SURNAME":"check1","PROFESSION":"QA1","AREA":"East"}');
$body->personalizations[0]->headers = PepipostLib\APIHelper::deserialize('{"header1_key":"header1_value"}');
$body->personalizations[0]->attachments = array();

$body->personalizations[0]->attachments[0] = new Models\Attachments;
$body->personalizations[0]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[0]->attachments[0]->name = 'zip2.zip';

$body->personalizations[0]->to = array();

$body->personalizations[0]->to[0] = new Models\EmailStruct;
$body->personalizations[0]->to[0]->name = 'random';
$body->personalizations[0]->to[0]->email = 'random@gmail.com';

$body->personalizations[0]->cc = array();

$body->personalizations[0]->cc[0] = new Models\EmailStruct;
$body->personalizations[0]->cc[0]->email = 'random@gmail.com';

$body->personalizations[0]->bcc = array();

$body->personalizations[0]->bcc[0] = new Models\EmailStruct;
$body->personalizations[0]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[0]->tokenTo = '{"tokenTo1_key": "tokenTo1_value"}';
$body->personalizations[0]->tokenCc = '{"tokencc1_key": "tokencc1_value"}';
$body->personalizations[0]->tokenBcc = '{"tokenbcc1_key": "tokenbcc1_value"}';

$body->settings = new Models\Settings;
$body->settings->footer = true;
$body->settings->clickTrack = true;
$body->settings->openTrack = true;
$body->settings->unsubscribeTrack = true;
$body->tags = array('check big payload', 'test');
$body->schedule = 0;
$body->bcc = array();

$body->bcc[0] = new Models\EmailStruct;
$body->bcc[0]->email = 'random@gmail.com';


try {
    $result = $mailSendController->createGeneratethemailsendrequest($body);
    var_dump($result);
} catch (PepipostLib\APIException $e) {
    echo 'Caught APIException: ',  $e->getMessage(), "\n"; 
}
```    

<a name="example2"></a>
## Single personalization with two recipient big token

```php
<?php

require_once "vendor/autoload.php";

use PepipostLib\Models;
use PepipostLib\Exceptions;

$apiKey = 'your api_key here';

$client = new PepipostLib\PepipostClient($apiKey);

$mailSendController = $client->getMailSend();

$body = new Models\Send;
$body->from = new Models\From;
$body->from->email = 'hello@your-register-domain-with-pepipost';
$body->from->name = 'Example Pepi';
$body->subject = 'Finalcheck4 [%NAME%] [%SURNAME%] [%PROFESSION%] [%AREA%]';
$body->content = array();

$body->content[0] = new Models\Content;
$body->content[0]->type = Models\TypeEnum::HTML;
$body->content[0]->value = '<html><body><p>This Avail FREEBIEES 1. [%NAME%] 2. [%SURNAME%] 3. [% PROFESSION %] 4. [%AREA%] Thishis</p><a href=\'https://uatdeveloper.yesbank.in/ibm_apim/activate/x?activationToken=eyJ1cmwiOiJodHRwczovLzEwLjAuNDAuMTc4L3YxL3BvcnRhbC91c2Vycy81YzMwNjZmOGU0YjBmZThmNjgwMTMyYzkvYWN0aXZhdGUiLCJ1c2VybmFtZSI6IiFCQVNFNjRfU0lWX0VOQyFfQWJURXBibHNMdzBsR3NXb2dJRXNZV2pwTnhFQmRpVXljRzdyQXMyZ1dkMS9BQUFBSEd4TldHYXdadGZXTXBMY3dZR3YrUE13elNGZkJyTUlhN0g1T1dGUGNtZDciLCJhdXRoZW50aWNhdGlvbiI6eyJ1c2VybmFtZSI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMi81NWUwMjQzMWU0YjA4MGZjMzM5ZDk5OTgvTjRnSzNwQjZsUjBsTzRySDRoWDhjQjFhWDZ3TTdnQzhzTjR1VTJxVzdkIiwicGFzc3dvcmQiOiJUZmRic0VoWjd6MXQxQjZhSG02cWxCRXlxWnhiL2ZZbkVNYUNaMjNMZDQifSwicHJvdmlkZXJDb250ZXh0Ijp7Im9yZ0lEIjoiNTVlMDI0MzBlNGIwODBmYzMzOWQ5OTkyIiwiZW52aXJvbm1lbnRJRCI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMiJ9fQ\'>Click Here</a><br><p>This is link 2</p><a href=\'https://www.amazon.com/ap/signin?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fcard%3Fie%3DUTF8%26ref_%3Dcust_rec_intestitial_signin\'>Click Here</a><p>This is link 3</p><a href=\'http://gadgets.ndtv.com/\'>Click Here</a><br></body></html>';

$body->attachments = array();

$body->attachments[0] = new Models\Attachments;
$body->attachments[0]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->attachments[0]->name = 'tesxt2.txt';

$body->personalizations = array();

$body->personalizations[0] = new Models\Personalizations;
$body->personalizations[0]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test1","SURNAME":"check1","PROFESSION":"QA1","AREA":"East"}');
$body->personalizations[0]->headers = PepipostLib\APIHelper::deserialize('{"header1_key":"header1_value"}');
$body->personalizations[0]->to = array();

$body->personalizations[0]->to[0] = new Models\EmailStruct;
$body->personalizations[0]->to[0]->name = 'random';
$body->personalizations[0]->to[0]->email = 'random@gmail.com';

$body->personalizations[0]->to[1] = new Models\EmailStruct;
$body->personalizations[0]->to[1]->name = 'random';
$body->personalizations[0]->to[1]->email = 'random@gmail.com';

$body->personalizations[0]->cc = array();

$body->personalizations[0]->cc[0] = new Models\EmailStruct;
$body->personalizations[0]->cc[0]->email = 'random@gmail.com';

$body->personalizations[0]->bcc = array();

$body->personalizations[0]->bcc[0] = new Models\EmailStruct;
$body->personalizations[0]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[0]->tokenTo = '{"tokenTo1_key": "tokenTo1_value","tokenTo2_key": "tokenTo2_value"}';
$body->personalizations[0]->tokenCc = '{"tokencc1_key": "tokencc1_value","tokencc2_key": "tokencc2_value"}';
$body->personalizations[0]->tokenBcc = '{"tokenbcc1_key": "tokenbcc1_value","tokenbcc2_key": "tokenbcc2_value"}';

$body->settings = new Models\Settings;
$body->settings->footer = true;
$body->settings->clickTrack = true;
$body->settings->openTrack = true;
$body->settings->unsubscribeTrack = true;
$body->tags = array('check big payload');
$body->schedule = 0;
$body->bcc = array();

$body->bcc[0] = new Models\EmailStruct;
$body->bcc[0]->email = 'random@gmail.com';


try {
    $result = $mailSendController->createGeneratethemailsendrequest($body);
    var_dump($result);
} catch (PepipostLib\APIException $e) {
    echo 'Caught APIException: ',  $e->getMessage(), "\n"; 
}
```    

<a name="example3"></a>
## Two personalization

```php
<?php

require_once "vendor/autoload.php";

use PepipostLib\Models;
use PepipostLib\Exceptions;

$apiKey = 'your api_key here';

$client = new PepipostLib\PepipostClient($apiKey);

$mailSendController = $client->getMailSend();

$body = new Models\Send;
$body->from = new Models\From;
$body->from->email = 'hello@your-register-domain-with-pepipost';
$body->from->name = 'Example Pepi';
$body->subject = 'livekatest1 [%NAME%] [%SURNAME%] [%PROFESSION%] [%AREA%]';
$body->templateId = 0;
$body->content = array();

$body->content[0] = new Models\Content;
$body->content[0]->type = Models\TypeEnum::HTML;
$body->content[0]->value = '<html><body><p>This Avail FREEBIEES 1. [%NAME%] 2. [%SURNAME%] 3. [% PROFESSION %] 4. [%AREA%] Thishis</p><a href=\'https://uatdeveloper.yesbank.in/ibm_apim/activate/x?activationToken=eyJ1cmwiOiJodHRwczovLzEwLjAuNDAuMTc4L3YxL3BvcnRhbC91c2Vycy81YzMwNjZmOGU0YjBmZThmNjgwMTMyYzkvYWN0aXZhdGUiLCJ1c2VybmFtZSI6IiFCQVNFNjRfU0lWX0VOQyFfQWJURXBibHNMdzBsR3NXb2dJRXNZV2pwTnhFQmRpVXljRzdyQXMyZ1dkMS9BQUFBSEd4TldHYXdadGZXTXBMY3dZR3YrUE13elNGZkJyTUlhN0g1T1dGUGNtZDciLCJhdXRoZW50aWNhdGlvbiI6eyJ1c2VybmFtZSI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMi81NWUwMjQzMWU0YjA4MGZjMzM5ZDk5OTgvTjRnSzNwQjZsUjBsTzRySDRoWDhjQjFhWDZ3TTdnQzhzTjR1VTJxVzdkIiwicGFzc3dvcmQiOiJUZmRic0VoWjd6MXQxQjZhSG02cWxCRXlxWnhiL2ZZbkVNYUNaMjNMZDQifSwicHJvdmlkZXJDb250ZXh0Ijp7Im9yZ0lEIjoiNTVlMDI0MzBlNGIwODBmYzMzOWQ5OTkyIiwiZW52aXJvbm1lbnRJRCI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMiJ9fQ\'>Click Here</a><br><p>This is link 2</p><a href=\'https://www.amazon.com/ap/signin?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fcard%3Fie%3DUTF8%26ref_%3Dcust_rec_intestitial_signin\'>Click Here</a><p>This is link 3</p><a href=\'http://gadgets.ndtv.com/\'>Click Here</a><br></body></html>';

$body->attachments = array();

$body->attachments[0] = new Models\Attachments;
$body->attachments[0]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->attachments[0]->name = 'tesxt2.txt';

$body->personalizations = array();

$body->personalizations[0] = new Models\Personalizations;
$body->personalizations[0]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test1","SURNAME":"check1","PROFESSION":"QA1","AREA":"East"}');
$body->personalizations[0]->headers = PepipostLib\APIHelper::deserialize('{"header1_key":"header1_value"}');
$body->personalizations[0]->attachments = array();

$body->personalizations[0]->attachments[0] = new Models\Attachments;
$body->personalizations[0]->attachments[0]->content = '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';
$body->personalizations[0]->attachments[0]->name = 'ipad.png';

$body->personalizations[0]->to = array();

$body->personalizations[0]->to[0] = new Models\EmailStruct;
$body->personalizations[0]->to[0]->name = 'random';
$body->personalizations[0]->to[0]->email = 'random@gmail.com';

$body->personalizations[0]->to[1] = new Models\EmailStruct;
$body->personalizations[0]->to[1]->name = 'random';
$body->personalizations[0]->to[1]->email = 'random@rediffmail.com';

$body->personalizations[0]->cc = array();

$body->personalizations[0]->cc[0] = new Models\EmailStruct;
$body->personalizations[0]->cc[0]->email = 'random@gmail.com';

$body->personalizations[0]->bcc = array();

$body->personalizations[0]->bcc[0] = new Models\EmailStruct;
$body->personalizations[0]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[0]->tokenTo = '{"tokenTo1_key": "tokenTo1_value","tokenTo2_key": "tokenTo2_value"}';
$body->personalizations[0]->tokenCc = '{"tokencc1_key": "tokencc1_value","tokencc2_key": "tokencc2_value"}';
$body->personalizations[0]->tokenBcc = '{"tokenbcc1_key": "tokenbcc1_value","tokenbcc2_key": "tokenbcc2_value"}';

$body->personalizations[1] = new Models\Personalizations;
$body->personalizations[1]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test2","SURNAME":"check2","PROFESSION":"QA2","AREA":"West"}');
$body->personalizations[1]->headers = PepipostLib\APIHelper::deserialize('{"header2_key":"header2_value"}');
$body->personalizations[1]->attachments = array();

$body->personalizations[1]->attachments[0] = new Models\Attachments;
$body->personalizations[1]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[1]->attachments[0]->name = 'zip2.zip';

$body->personalizations[1]->to = array();

$body->personalizations[1]->to[0] = new Models\EmailStruct;
$body->personalizations[1]->to[0]->name = 'random';
$body->personalizations[1]->to[0]->email = 'random@yahoo.com';

$body->personalizations[1]->to[1] = new Models\EmailStruct;
$body->personalizations[1]->to[1]->name = 'random';
$body->personalizations[1]->to[1]->email = 'random@outlook.com';

$body->personalizations[1]->cc = array();

$body->personalizations[1]->cc[0] = new Models\EmailStruct;
$body->personalizations[1]->cc[0]->email = 'random@gmail.com';

$body->personalizations[1]->bcc = array();

$body->personalizations[1]->bcc[0] = new Models\EmailStruct;
$body->personalizations[1]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[1]->tokenTo = '{"tokenTo3_key": "tokenTo3_value","tokenTo4_key": "tokenTo4_value"}';
$body->personalizations[1]->tokenCc = '{"tokencc5_key": "tokencc5_value","tokencc6_key": "tokencc6_value"}';
$body->personalizations[1]->tokenBcc = '{"tokenbcc7_key": "tokenbcc7_value","tokenbcc8_key": "tokenbcc8_value"}';

$body->settings = new Models\Settings;
$body->settings->footer = true;
$body->settings->clickTrack = true;
$body->settings->openTrack = true;
$body->settings->unsubscribeTrack = true;
$body->tags = array('check big payload');
$body->schedule = 0;
$body->bcc = array();

$body->bcc[0] = new Models\EmailStruct;
$body->bcc[0]->email = 'random@gmail.com';


try {
    $result = $mailSendController->createGeneratethemailsendrequest($body);
    var_dump($result);
} catch (PepipostLib\APIException $e) {
    echo 'Caught APIException: ',  $e->getMessage(), "\n"; 
}
```

<a name="example4"></a>
## Multiple personalization

```php
<?php

require_once "vendor/autoload.php";

use PepipostLib\Models;
use PepipostLib\Exceptions;

$apiKey = 'your api_key here';

$client = new PepipostLib\PepipostClient($apiKey);

$mailSendController = $client->getMailSend();

$body = new Models\Send;
$body->from = new Models\From;
$body->from->email = 'hello@your-register-domain-with-pepipost';
$body->from->name = 'Example Pepi';
$body->subject = 'livekatest2 [%NAME%] [%SURNAME%] [%PROFESSION%] [%AREA%]';
$body->templateId = 22299;
$body->content = array();

$body->content[0] = new Models\Content;
$body->content[0]->type = Models\TypeEnum::HTML;
$body->content[0]->value = '<html><body><p>This Avail FREEBIEES 1. [%NAME%] 2. [%SURNAME%] 3. [% PROFESSION %] 4. [%AREA%] Thishis</p><a href=\'https://uatdeveloper.yesbank.in/ibm_apim/activate/x?activationToken=eyJ1cmwiOiJodHRwczovLzEwLjAuNDAuMTc4L3YxL3BvcnRhbC91c2Vycy81YzMwNjZmOGU0YjBmZThmNjgwMTMyYzkvYWN0aXZhdGUiLCJ1c2VybmFtZSI6IiFCQVNFNjRfU0lWX0VOQyFfQWJURXBibHNMdzBsR3NXb2dJRXNZV2pwTnhFQmRpVXljRzdyQXMyZ1dkMS9BQUFBSEd4TldHYXdadGZXTXBMY3dZR3YrUE13elNGZkJyTUlhN0g1T1dGUGNtZDciLCJhdXRoZW50aWNhdGlvbiI6eyJ1c2VybmFtZSI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMi81NWUwMjQzMWU0YjA4MGZjMzM5ZDk5OTgvTjRnSzNwQjZsUjBsTzRySDRoWDhjQjFhWDZ3TTdnQzhzTjR1VTJxVzdkIiwicGFzc3dvcmQiOiJUZmRic0VoWjd6MXQxQjZhSG02cWxCRXlxWnhiL2ZZbkVNYUNaMjNMZDQifSwicHJvdmlkZXJDb250ZXh0Ijp7Im9yZ0lEIjoiNTVlMDI0MzBlNGIwODBmYzMzOWQ5OTkyIiwiZW52aXJvbm1lbnRJRCI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMiJ9fQ\'>Click Here</a><br><p>This is link 2</p><a href=\'https://www.amazon.com/ap/signin?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fcard%3Fie%3DUTF8%26ref_%3Dcust_rec_intestitial_signin\'>Click Here</a><p>This is link 3</p><a href=\'http://gadgets.ndtv.com/\'>Click Here</a><br></body></html>';

$body->attachments = array();

$body->attachments[0] = new Models\Attachments;
$body->attachments[0]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->attachments[0]->name = 'tesxt2.txt';

$body->personalizations = array();

$body->personalizations[0] = new Models\Personalizations;
$body->personalizations[0]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test1","SURNAME":"check1","PROFESSION":"QA1","AREA":"East"}');
$body->personalizations[0]->headers = PepipostLib\APIHelper::deserialize('{"header1_key":"header1_value"}');
$body->personalizations[0]->attachments = array();

$body->personalizations[0]->attachments[0] = new Models\Attachments;
$body->personalizations[0]->attachments[0]->content = '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';
$body->personalizations[0]->attachments[0]->name = 'ipad.png';

$body->personalizations[0]->to = array();

$body->personalizations[0]->to[0] = new Models\EmailStruct;
$body->personalizations[0]->to[0]->name = 'random';
$body->personalizations[0]->to[0]->email = 'random@gmail.com';

$body->personalizations[0]->to[1] = new Models\EmailStruct;
$body->personalizations[0]->to[1]->name = 'random';
$body->personalizations[0]->to[1]->email = 'testarandomrtstar@gmail.com';

$body->personalizations[0]->cc = array();

$body->personalizations[0]->cc[0] = new Models\EmailStruct;
$body->personalizations[0]->cc[0]->email = 'random@gmail.com';

$body->personalizations[0]->bcc = array();

$body->personalizations[0]->bcc[0] = new Models\EmailStruct;
$body->personalizations[0]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[0]->tokenTo = '{"tokenTo1_key": "tokenTo1_value","tokenTo2_key": "tokenTo2_value"}';
$body->personalizations[0]->tokenCc = '{"tokencc1_key": "tokencc1_value","tokencc2_key": "tokencc2_value"}';
$body->personalizations[0]->tokenBcc = '{"tokenbcc1_key": "tokenbcc1_value","tokenbcc2_key": "tokenbcc2_value"}';

$body->personalizations[1] = new Models\Personalizations;
$body->personalizations[1]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test2","SURNAME":"check2","PROFESSION":"QA2","AREA":"West"}');
$body->personalizations[1]->headers = PepipostLib\APIHelper::deserialize('{"header2_key":"header2_value"}');
$body->personalizations[1]->attachments = array();

$body->personalizations[1]->attachments[0] = new Models\Attachments;
$body->personalizations[1]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[1]->attachments[0]->name = 'zip2.zip';

$body->personalizations[1]->to = array();

$body->personalizations[1]->to[0] = new Models\EmailStruct;
$body->personalizations[1]->to[0]->name = 'random';
$body->personalizations[1]->to[0]->email = 'random@outlook.com';

$body->personalizations[1]->cc = array();

$body->personalizations[1]->cc[0] = new Models\EmailStruct;
$body->personalizations[1]->cc[0]->email = 'random@rediffmail.com';

$body->personalizations[1]->bcc = array();

$body->personalizations[1]->bcc[0] = new Models\EmailStruct;
$body->personalizations[1]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[1]->tokenTo = '{"tokenTo3_key": "tokenTo3_value","tokenTo4_key": "tokenTo4_value"}';
$body->personalizations[1]->tokenCc = '{"tokencc3_key": "tokencc3_value","tokencc4_key": "tokencc4_value"}';
$body->personalizations[1]->tokenBcc = '{"tokenbcc3_key": "tokenbcc3_value","tokenbcc3_key": "tokenbcc4_value"}';

$body->personalizations[2] = new Models\Personalizations;
$body->personalizations[2]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test3","SURNAME":"check3","PROFESSION":"QA3","AREA":"North"}');
$body->personalizations[2]->headers = PepipostLib\APIHelper::deserialize('{"header3_key":"header3_value"}');
$body->personalizations[2]->attachments = array();

$body->personalizations[2]->attachments[0] = new Models\Attachments;
$body->personalizations[2]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[2]->attachments[0]->name = 'zip2.zip';

$body->personalizations[2]->to = array();

$body->personalizations[2]->to[0] = new Models\EmailStruct;
$body->personalizations[2]->to[0]->name = 'random';
$body->personalizations[2]->to[0]->email = 'random@yahoo.com';

$body->personalizations[2]->cc = array();

$body->personalizations[2]->cc[0] = new Models\EmailStruct;
$body->personalizations[2]->cc[0]->email = 'random@rediffmail.com';

$body->personalizations[2]->bcc = array();

$body->personalizations[2]->bcc[0] = new Models\EmailStruct;
$body->personalizations[2]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[2]->tokenTo = '{"tokenTo5_key": "tokenTo5_value","tokenTo6_key": "tokenTo6_value"}';
$body->personalizations[2]->tokenCc = '{"tokencc5_key": "tokencc5_value","tokencc6_key": "tokencc6_value"}';
$body->personalizations[2]->tokenBcc = '{"tokenbcc5_key": "tokenbcc5_value","tokenbcc6_key": "tokenbcc6_value"}';

$body->personalizations[3] = new Models\Personalizations;
$body->personalizations[3]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test4","SURNAME":"check4","PROFESSION":"QA4","AREA":"south"}');
$body->personalizations[3]->headers = PepipostLib\APIHelper::deserialize('{"header4_key":"header4_value"}');
$body->personalizations[3]->attachments = array();

$body->personalizations[3]->attachments[0] = new Models\Attachments;
$body->personalizations[3]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[3]->attachments[0]->name = 'zip2.zip';

$body->personalizations[3]->to = array();

$body->personalizations[3]->to[0] = new Models\EmailStruct;
$body->personalizations[3]->to[0]->name = 'random';
$body->personalizations[3]->to[0]->email = 'random@outlook.com';

$body->personalizations[3]->cc = array();

$body->personalizations[3]->cc[0] = new Models\EmailStruct;
$body->personalizations[3]->cc[0]->email = 'random@rediffmail.com';

$body->personalizations[3]->bcc = array();

$body->personalizations[3]->bcc[0] = new Models\EmailStruct;
$body->personalizations[3]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[3]->tokenTo = '{"tokenTo7_key": "tokenTo7_value","tokenTo8_key": "tokenTo8_value"}';
$body->personalizations[3]->tokenCc = '{"tokencc7_key": "tokencc7_value","tokencc8_key": "tokencc8_value"}';
$body->personalizations[3]->tokenBcc = '{"tokenbcc7_key": "tokenbcc7_value","tokenbcc8_key": "tokenbcc8_value"}';

$body->personalizations[4] = new Models\Personalizations;
$body->personalizations[4]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test5","SURNAME":"check5","PROFESSION":"QA5","AREA":"northeast"}');
$body->personalizations[4]->headers = PepipostLib\APIHelper::deserialize('{"header5_key":"header5_value"}');
$body->personalizations[4]->attachments = array();

$body->personalizations[4]->attachments[0] = new Models\Attachments;
$body->personalizations[4]->attachments[0]->content = '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';
$body->personalizations[4]->attachments[0]->name = 'ipad.png';

$body->personalizations[4]->to = array();

$body->personalizations[4]->to[0] = new Models\EmailStruct;
$body->personalizations[4]->to[0]->name = 'random';
$body->personalizations[4]->to[0]->email = 'ttesrandomttry758@gmail.com';

$body->personalizations[4]->to[1] = new Models\EmailStruct;
$body->personalizations[4]->to[1]->name = 'random';
$body->personalizations[4]->to[1]->email = 'random@gmail.com';

$body->personalizations[4]->cc = array();

$body->personalizations[4]->cc[0] = new Models\EmailStruct;
$body->personalizations[4]->cc[0]->email = 'random@gmail.com';

$body->personalizations[4]->bcc = array();

$body->personalizations[4]->bcc[0] = new Models\EmailStruct;
$body->personalizations[4]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[4]->tokenTo = '{"tokenTo9_key": "tokenTo9_value","tokenTo10_key": "tokenTo10_value"}';
$body->personalizations[4]->tokenCc = '{"tokencc9_key": "tokencc9_value","tokencc10_key": "tokencc10_value"}';
$body->personalizations[4]->tokenBcc = '{"tokenbcc9_key": "tokenbcc9_value","tokenbcc10_key": "tokenbcc10_value"}';

$body->personalizations[5] = new Models\Personalizations;
$body->personalizations[5]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test6","SURNAME":"check6","PROFESSION":"QA6","AREA":"northwest"}');
$body->personalizations[5]->headers = PepipostLib\APIHelper::deserialize('{"header6_key":"header6_value"}');
$body->personalizations[5]->attachments = array();

$body->personalizations[5]->attachments[0] = new Models\Attachments;
$body->personalizations[5]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[5]->attachments[0]->name = 'zip2.zip';

$body->personalizations[5]->to = array();

$body->personalizations[5]->to[0] = new Models\EmailStruct;
$body->personalizations[5]->to[0]->name = 'random';
$body->personalizations[5]->to[0]->email = 'random@outlook.com';

$body->personalizations[5]->cc = array();

$body->personalizations[5]->cc[0] = new Models\EmailStruct;
$body->personalizations[5]->cc[0]->email = 'random@rediffmail.com';

$body->personalizations[5]->bcc = array();

$body->personalizations[5]->bcc[0] = new Models\EmailStruct;
$body->personalizations[5]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[5]->tokenTo = '{"tokenTo11_key": "tokenTo11_value","tokenTo12_key": "tokenTo12_value"}';
$body->personalizations[5]->tokenCc = '{"tokencc11_key": "tokencc11_value","tokencc12_key": "tokencc12_value"}';
$body->personalizations[5]->tokenBcc = '{"tokenbcc11_key": "tokenbcc11_value","tokenbcc12_key": "tokenbcc12_value"}';

$body->personalizations[6] = new Models\Personalizations;
$body->personalizations[6]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test7","SURNAME":"check7","PROFESSION":"QA7","AREA":"southest"}');
$body->personalizations[6]->headers = PepipostLib\APIHelper::deserialize('{"header7_key":"header7_value"}');
$body->personalizations[6]->attachments = array();

$body->personalizations[6]->attachments[0] = new Models\Attachments;
$body->personalizations[6]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[6]->attachments[0]->name = 'zip2.zip';

$body->personalizations[6]->to = array();

$body->personalizations[6]->to[0] = new Models\EmailStruct;
$body->personalizations[6]->to[0]->name = 'archana3';
$body->personalizations[6]->to[0]->email = 'random@yahoo.com';

$body->personalizations[6]->cc = array();

$body->personalizations[6]->cc[0] = new Models\EmailStruct;
$body->personalizations[6]->cc[0]->email = 'random@rediffmail.com';

$body->personalizations[6]->bcc = array();

$body->personalizations[6]->bcc[0] = new Models\EmailStruct;
$body->personalizations[6]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[6]->tokenTo = '{"tokenTo13_key": "tokenTo13_value","tokenTo14_key": "tokenTo6_value"}';
$body->personalizations[6]->tokenCc = '{"tokencc13_key": "tokencc13_value","tokencc14_key": "tokencc6_value"}';
$body->personalizations[6]->tokenBcc = '{"tokenbcc13_key": "tokenbcc13_value","tokenbcc14_key": "tokenbcc14_value"}';

$body->personalizations[7] = new Models\Personalizations;
$body->personalizations[7]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test8","SURNAME":"check8","PROFESSION":"QA8","AREA":"southwest"}');
$body->personalizations[7]->headers = PepipostLib\APIHelper::deserialize('{"header8_key":"header8_value"}');
$body->personalizations[7]->attachments = array();

$body->personalizations[7]->attachments[0] = new Models\Attachments;
$body->personalizations[7]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[7]->attachments[0]->name = 'zip2.zip';

$body->personalizations[7]->to = array();

$body->personalizations[7]->to[0] = new Models\EmailStruct;
$body->personalizations[7]->to[0]->name = 'random';
$body->personalizations[7]->to[0]->email = 'random@outlook.com';

$body->personalizations[7]->cc = array();

$body->personalizations[7]->cc[0] = new Models\EmailStruct;
$body->personalizations[7]->cc[0]->email = 'random@rediffmail.com';

$body->personalizations[7]->bcc = array();

$body->personalizations[7]->bcc[0] = new Models\EmailStruct;
$body->personalizations[7]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[7]->tokenTo = '{"tokenTo15_key": "tokenTo15_value","tokenTo16_key": "tokenTo16_value"}';
$body->personalizations[7]->tokenCc = '{"tokencc15_key": "tokencc15_value","tokencc16_key": "tokencc16_value"}';
$body->personalizations[7]->tokenBcc = '{"tokenbcc15_key": "tokenbcc15_value","tokenbcc16_key": "tokenbcc16_value"}';

$body->personalizations[8] = new Models\Personalizations;
$body->personalizations[8]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test9","SURNAME":"check9","PROFESSION":"QA9","AREA":"suthnorth"}');
$body->personalizations[8]->headers = PepipostLib\APIHelper::deserialize('{"header9_key":"header9_value"}');
$body->personalizations[8]->attachments = array();

$body->personalizations[8]->attachments[0] = new Models\Attachments;
$body->personalizations[8]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[8]->attachments[0]->name = 'zip2.zip';

$body->personalizations[8]->to = array();

$body->personalizations[8]->to[0] = new Models\EmailStruct;
$body->personalizations[8]->to[0]->name = 'random';
$body->personalizations[8]->to[0]->email = 'random@yahoo.com';

$body->personalizations[8]->cc = array();

$body->personalizations[8]->cc[0] = new Models\EmailStruct;
$body->personalizations[8]->cc[0]->email = 'random@rediffmail.com';

$body->personalizations[8]->bcc = array();

$body->personalizations[8]->bcc[0] = new Models\EmailStruct;
$body->personalizations[8]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[8]->tokenTo = '{"tokenTo17_key": "tokenTo17_value","tokenTo18_key": "tokenTo18_value"}';
$body->personalizations[8]->tokenCc = '{"tokencc17_key": "tokencc17_value","tokencc18_key": "tokencc18_value"}';
$body->personalizations[8]->tokenBcc = '{"tokenbcc17_key": "tokenbcc17_value","tokenbcc18_key": "tokenbcc18_value"}';

$body->settings = new Models\Settings;
$body->settings->footer = true;
$body->settings->clickTrack = true;
$body->settings->openTrack = true;
$body->settings->unsubscribeTrack = true;
$body->tags = array('check big payload');
$body->schedule = 0;
$body->bcc = array();

$body->bcc[0] = new Models\EmailStruct;
$body->bcc[0]->email = 'random@gmail.com';


try {
    $result = $mailSendController->createGeneratethemailsendrequest($body);
    var_dump($result);
} catch (PepipostLib\APIException $e) {
    echo 'Caught APIException: ',  $e->getMessage(), "\n"; 
}
```

<a name="example5"></a>
## Without attachment check scheduling

```php
<?php

require_once "vendor/autoload.php";

use PepipostLib\Models;
use PepipostLib\Exceptions;

$apiKey = 'your api_key here';

$client = new PepipostLib\PepipostClient($apiKey);

$mailSendController = $client->getMailSend();

$body = new Models\Send;
$body->from = new Models\From;
$body->from->email = 'hello@your-register-domain-with-pepipost';
$body->from->name = 'Example Pepi';
$body->subject = 'scheduleval2 [%NAME%] [%SURNAME%] [%PROFESSION%] [%AREA%]';
$body->templateId = 10;
$body->content = array();

$body->content[0] = new Models\Content;
$body->content[0]->type = Models\TypeEnum::HTML;
$body->content[0]->value = '<html><body><p>This Avail FREEBIEES 1. [%NAME%] 2. [%SURNAME%] 3. [% PROFESSION %] 4. [%AREA%] Thishis</p><a href=\'https://uatdeveloper.yesbank.in/ibm_apim/activate/x?activationToken=eyJ1cmwiOiJodHRwczovLzEwLjAuNDAuMTc4L3YxL3BvcnRhbC91c2Vycy81YzMwNjZmOGU0YjBmZThmNjgwMTMyYzkvYWN0aXZhdGUiLCJ1c2VybmFtZSI6IiFCQVNFNjRfU0lWX0VOQyFfQWJURXBibHNMdzBsR3NXb2dJRXNZV2pwTnhFQmRpVXljRzdyQXMyZ1dkMS9BQUFBSEd4TldHYXdadGZXTXBMY3dZR3YrUE13elNGZkJyTUlhN0g1T1dGUGNtZDciLCJhdXRoZW50aWNhdGlvbiI6eyJ1c2VybmFtZSI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMi81NWUwMjQzMWU0YjA4MGZjMzM5ZDk5OTgvTjRnSzNwQjZsUjBsTzRySDRoWDhjQjFhWDZ3TTdnQzhzTjR1VTJxVzdkIiwicGFzc3dvcmQiOiJUZmRic0VoWjd6MXQxQjZhSG02cWxCRXlxWnhiL2ZZbkVNYUNaMjNMZDQifSwicHJvdmlkZXJDb250ZXh0Ijp7Im9yZ0lEIjoiNTVlMDI0MzBlNGIwODBmYzMzOWQ5OTkyIiwiZW52aXJvbm1lbnRJRCI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMiJ9fQ\'>Click Here</a><br><p>This is link 2</p><a href=\'https://www.amazon.com/ap/signin?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fcard%3Fie%3DUTF8%26ref_%3Dcust_rec_intestitial_signin\'>Click Here</a><p>This is link 3</p><a href=\'http://gadgets.ndtv.com/\'>Click Here</a><br></body></html>';

$body->attachments = array();

$body->attachments[0] = new Models\Attachments;
$body->attachments[0]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->attachments[0]->name = 'tesxt2.txt';

$body->personalizations = array();

$body->personalizations[0] = new Models\Personalizations;
$body->personalizations[0]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test1","SURNAME":"check1","PROFESSION":"QA1","AREA":"East"}');
$body->personalizations[0]->headers = PepipostLib\APIHelper::deserialize('{"header1_key":"header1_value"}');
$body->personalizations[0]->to = array();

$body->personalizations[0]->to[0] = new Models\EmailStruct;
$body->personalizations[0]->to[0]->name = 'random';
$body->personalizations[0]->to[0]->email = 'random@gmail.com';

$body->personalizations[0]->to[1] = new Models\EmailStruct;
$body->personalizations[0]->to[1]->name = 'random';
$body->personalizations[0]->to[1]->email = 'random@gmail.com';

$body->personalizations[0]->cc = array();

$body->personalizations[0]->cc[0] = new Models\EmailStruct;
$body->personalizations[0]->cc[0]->email = 'random@gmail.com';

$body->personalizations[0]->bcc = array();

$body->personalizations[0]->bcc[0] = new Models\EmailStruct;
$body->personalizations[0]->bcc[0]->email = 'testartstar2@gmail.com';

$body->personalizations[0]->tokenTo = '{"tokenTo1_key": "tokenTo1_value","tokenTo2_key": "tokenTo2_value"}';
$body->personalizations[0]->tokenCc = '{"tokencc1_key": "tokencc1_value","tokencc2_key": "tokencc2_value"}';
$body->personalizations[0]->tokenBcc = '{"tokenbcc1_key": "tokenbcc1_value","tokenbcc2_key": "tokenbcc2_value"}';

$body->settings = new Models\Settings;
$body->settings->footer = true;
$body->settings->clickTrack = true;
$body->settings->openTrack = true;
$body->settings->unsubscribeTrack = true;
$body->tags = array('check big payload');
$body->schedule = 0;
$body->bcc = array();

$body->bcc[0] = new Models\EmailStruct;
$body->bcc[0]->email = 'random@gmail.com';


try {
    $result = $mailSendController->createGeneratethemailsendrequest($body);
    var_dump($result);
} catch (PepipostLib\APIException $e) {
    echo 'Caught APIException: ',  $e->getMessage(), "\n"; 
}
```

<a name="example6"></a>
## Multiple to

```php
<?php

require_once "vendor/autoload.php";

use PepipostLib\Models;
use PepipostLib\Exceptions;

$apiKey = 'your api_key here';

$client = new PepipostLib\PepipostClient($apiKey);

$mailSendController = $client->getMailSend();

$body = new Models\Send;
$body->from = new Models\From;
$body->from->email = 'hello@your-register-domain-with-pepipost';
$body->from->name = 'Example Pepi';
$body->subject = 'issuecheck6 [%NAME%] [%SURNAME%] [%PROFESSION%] [%AREA%] [%POST%]';
$body->content = array();

$body->content[0] = new Models\Content;
$body->content[0]->type = Models\TypeEnum::HTML;
$body->content[0]->value = '<html><body><p>This Avail FREEBIEES 1. [%NAME%] 2. [%SURNAME%] 3. [% PROFESSION %] 4. [%AREA%] Thishis</p><a href=\'https://uatdeveloper.yesbank.in/ibm_apim/activate/x?activationToken=eyJ1cmwiOiJodHRwczovLzEwLjAuNDAuMTc4L3YxL3BvcnRhbC91c2Vycy81YzMwNjZmOGU0YjBmZThmNjgwMTMyYzkvYWN0aXZhdGUiLCJ1c2VybmFtZSI6IiFCQVNFNjRfU0lWX0VOQyFfQWJURXBibHNMdzBsR3NXb2dJRXNZV2pwTnhFQmRpVXljRzdyQXMyZ1dkMS9BQUFBSEd4TldHYXdadGZXTXBMY3dZR3YrUE13elNGZkJyTUlhN0g1T1dGUGNtZDciLCJhdXRoZW50aWNhdGlvbiI6eyJ1c2VybmFtZSI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMi81NWUwMjQzMWU0YjA4MGZjMzM5ZDk5OTgvTjRnSzNwQjZsUjBsTzRySDRoWDhjQjFhWDZ3TTdnQzhzTjR1VTJxVzdkIiwicGFzc3dvcmQiOiJUZmRic0VoWjd6MXQxQjZhSG02cWxCRXlxWnhiL2ZZbkVNYUNaMjNMZDQifSwicHJvdmlkZXJDb250ZXh0Ijp7Im9yZ0lEIjoiNTVlMDI0MzBlNGIwODBmYzMzOWQ5OTkyIiwiZW52aXJvbm1lbnRJRCI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMiJ9fQ\'>Click Here</a><br><p>This is link 2</p><a href=\'https://www.amazon.com/ap/signin?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fcard%3Fie%3DUTF8%26ref_%3Dcust_rec_intestitial_signin\'>Click Here</a><p>This is link 3</p><a href=\'http://gadgets.ndtv.com/\'>Click Here</a><br></body></html>';

$body->attachments = array();

$body->attachments[0] = new Models\Attachments;
$body->attachments[0]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->attachments[0]->name = 'tesxt2.txt';

$body->personalizations = array();

$body->personalizations[0] = new Models\Personalizations;
$body->personalizations[0]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test1","SURNAME":"check1","PROFESSION":"QA1","AREA":"East","POST":12345}');
$body->personalizations[0]->headers = PepipostLib\APIHelper::deserialize('{"header1_key":"header1_value"}');
$body->personalizations[0]->to = array();

$body->personalizations[0]->to[0] = new Models\EmailStruct;
$body->personalizations[0]->to[0]->name = 'random';
$body->personalizations[0]->to[0]->email = 'ttesttrandomry758@gmail.com';

$body->personalizations[0]->to[1] = new Models\EmailStruct;
$body->personalizations[0]->to[1]->email = 'random@gmail.com';

$body->personalizations[0]->to[2] = new Models\EmailStruct;
$body->personalizations[0]->to[2]->email = 'testarrandomtstar@yahoo.com';

$body->personalizations[0]->to[3] = new Models\EmailStruct;
$body->personalizations[0]->to[3]->email = 'random0@gmail.com';

$body->personalizations[0]->cc = array();

$body->personalizations[0]->cc[0] = new Models\EmailStruct;
$body->personalizations[0]->cc[0]->email = 'random@gmail.com';

$body->personalizations[0]->bcc = array();

$body->personalizations[0]->bcc[0] = new Models\EmailStruct;
$body->personalizations[0]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[0]->tokenTo = '{"tokenTo1_key": "tokenTo1_value","tokenTo2_key": "tokenTo2_value"}';
$body->personalizations[0]->tokenCc = '{"tokencc1_key": "tokencc1_value","tokencc2_key": "tokencc2_value"}';
$body->personalizations[0]->tokenBcc = '{"tokenbcc1_key": "tokenbcc1_value","tokenbcc2_key": "tokenbcc2_value"}';

$body->personalizations[1] = new Models\Personalizations;
$body->personalizations[1]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test2","SURNAME":"check2","PROFESSION":"QA2","AREA":"West","POST":6789}');
$body->personalizations[1]->headers = PepipostLib\APIHelper::deserialize('{"header2_key":"header2_value"}');
$body->personalizations[1]->to = array();

$body->personalizations[1]->to[0] = new Models\EmailStruct;
$body->personalizations[1]->to[0]->name = 'random';
$body->personalizations[1]->to[0]->email = 'random@yahoo.com';

$body->personalizations[1]->to[1] = new Models\EmailStruct;
$body->personalizations[1]->to[1]->name = 'random';
$body->personalizations[1]->to[1]->email = 'random@outlook.com';

$body->personalizations[1]->to[2] = new Models\EmailStruct;
$body->personalizations[1]->to[2]->name = 'random';
$body->personalizations[1]->to[2]->email = 'random@rediffmail.com';

$body->personalizations[1]->to[3] = new Models\EmailStruct;
$body->personalizations[1]->to[3]->name = 'random';
$body->personalizations[1]->to[3]->email = 'random@gmail.com';

$body->personalizations[1]->cc = array();

$body->personalizations[1]->cc[0] = new Models\EmailStruct;
$body->personalizations[1]->cc[0]->email = 'random@outlook.com';

$body->personalizations[1]->bcc = array();

$body->personalizations[1]->bcc[0] = new Models\EmailStruct;
$body->personalizations[1]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[1]->tokenTo = '{"tokenTo3_key": "tokenTo3_value","tokenTo4_key": "tokenTo4_value"}';
$body->personalizations[1]->tokenCc = '{"tokencc5_key": "tokencc5_value","tokencc6_key": "tokencc6_value"}';
$body->personalizations[1]->tokenBcc = '{"tokenbcc7_key": "tokenbcc7_value","tokenbcc8_key": "tokenbcc8_value"}';

$body->settings = new Models\Settings;
$body->settings->footer = true;
$body->settings->clickTrack = true;
$body->settings->openTrack = true;
$body->settings->unsubscribeTrack = true;
$body->tags = array('checkbigpayload');
$body->schedule = 0;
$body->bcc = array();

$body->bcc[0] = new Models\EmailStruct;
$body->bcc[0]->email = 'random@gmail.com';


try {
    $result = $mailSendController->createGeneratethemailsendrequest($body);
    var_dump($result);
} catch (PepipostLib\APIException $e) {
    echo 'Caught APIException: ',  $e->getMessage(), "\n"; 
}
```

<a name="example7"></a>
## Multiple cc

```php
<?php

require_once "vendor/autoload.php";

use PepipostLib\Models;
use PepipostLib\Exceptions;

$apiKey = 'your api_key here';

$client = new PepipostLib\PepipostClient($apiKey);

$mailSendController = $client->getMailSend();

$body = new Models\Send;
$body->from = new Models\From;
$body->from->email = 'hello@your-register-domain-with-pepipost';
$body->from->name = 'Example Pepi';
$body->subject = 'day2test1 [%NAME%] [%SURNAME%] [%PROFESSION%] [%AREA%] [%POST%]';
$body->content = array();

$body->content[0] = new Models\Content;
$body->content[0]->type = Models\TypeEnum::HTML;
$body->content[0]->value = '<html><body><p>This Avail FREEBIEES 1. [%NAME%] 2. [%SURNAME%] 3. [% PROFESSION %] 4. [%AREA%] Thishis</p><a href=\'https://uatdeveloper.yesbank.in/ibm_apim/activate/x?activationToken=eyJ1cmwiOiJodHRwczovLzEwLjAuNDAuMTc4L3YxL3BvcnRhbC91c2Vycy81YzMwNjZmOGU0YjBmZThmNjgwMTMyYzkvYWN0aXZhdGUiLCJ1c2VybmFtZSI6IiFCQVNFNjRfU0lWX0VOQyFfQWJURXBibHNMdzBsR3NXb2dJRXNZV2pwTnhFQmRpVXljRzdyQXMyZ1dkMS9BQUFBSEd4TldHYXdadGZXTXBMY3dZR3YrUE13elNGZkJyTUlhN0g1T1dGUGNtZDciLCJhdXRoZW50aWNhdGlvbiI6eyJ1c2VybmFtZSI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMi81NWUwMjQzMWU0YjA4MGZjMzM5ZDk5OTgvTjRnSzNwQjZsUjBsTzRySDRoWDhjQjFhWDZ3TTdnQzhzTjR1VTJxVzdkIiwicGFzc3dvcmQiOiJUZmRic0VoWjd6MXQxQjZhSG02cWxCRXlxWnhiL2ZZbkVNYUNaMjNMZDQifSwicHJvdmlkZXJDb250ZXh0Ijp7Im9yZ0lEIjoiNTVlMDI0MzBlNGIwODBmYzMzOWQ5OTkyIiwiZW52aXJvbm1lbnRJRCI6IjU1ZTAyNzQ0ZTRiMDgwZmMzMzlkOTliMiJ9fQ\'>Click Here</a><br><p>This is link 2</p><a href=\'https://www.amazon.com/ap/signin?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fcard%3Fie%3DUTF8%26ref_%3Dcust_rec_intestitial_signin\'>Click Here</a><p>This is link 3</p><a href=\'http://gadgets.ndtv.com/\'>Click Here</a><br></body></html>';

$body->attachments = array();

$body->attachments[0] = new Models\Attachments;
$body->attachments[0]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->attachments[0]->name = 'tesxt2.txt';

$body->personalizations = array();

$body->personalizations[0] = new Models\Personalizations;
$body->personalizations[0]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test1","SURNAME":"check1","PROFESSION":"QA1","AREA":"East","POST":12345}');
$body->personalizations[0]->headers = PepipostLib\APIHelper::deserialize('{"header1_key":"header1_value"}');
$body->personalizations[0]->attachments = array();

$body->personalizations[0]->attachments[0] = new Models\Attachments;
$body->personalizations[0]->attachments[0]->content = '/9j/4AAQSkZJRgABAQIAUQBRAAD/2wBDAP//////////////////////////////////////////////////////////////////////////////////////2wBDAf//////////////////////////////////////////////////////////////////////////////////////wAARCAUbB7EDASIAAhEBAxEB/8QAFwABAQEBAAAAAAAAAAAAAAAAAAECA//EAB4QAQEBAAMBAQEBAQAAAAAAAAABEQISMVFBIWFx/8QAFgEBAQEAAAAAAAAAAAAAAAAAAAEC/8QAFxEBAQEBAAAAAAAAAAAAAAAAAAERMf/aAAwDAQACEQMRAD8A6AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlAtNRGdXGxmVprUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGRGbVAAFlQBsZlaaQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZtLRLVEVEAAAAUalZBGxIrSAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAmpqaLqaCaoACAAAAACgAK0wspErQDSAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACWlRLVAEAAAAEAAAAAFAAAAaisxpYyAKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJQSgMqAAAAIqAAAACgAAAAADUv4yCNgNIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMraiVQBAAAAAQAAAABQAAAAAAAFjTDUWJVAVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGbQXS1BnVAAAAAAAAQAAAUAAAAAAAAAAWIA2JFaZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASoDKgAAAAAAACAAAAAKAAAAAAAAAAAAsaYbixKAKgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlNRLVAEAAAAAABFQFQAABQAAAAAAAAAAAAABYgDYDTIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJqamjWs6CaoAAAAAAAACAqAAAAAKAAAAAAAAAAAAAAAA1FZnrSxmgCgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADKaLqAmqAAAAAAAAAAAAIAAAAAoAAAAAAAAAAAAAAAAAA2w1FiVQFQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASqylABFAAAAAAAAAAAAEAAAAAUAAAAAAAAAAAAAAAAAAAAWIQGwGmQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEtAqAyoAAAAAAAAAAAAgAAAACgAAAAAAAAAAAAAAAAigAAAAAA2JPFaZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABNRNDQEUAAAAAAAAAABAVAAAAAFAAAAAAAAAAAAAAAAAARQARUBQAAAanisxpZxmgCgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADOguoDOqAAAAAAAAAAAAAgAAAAoAAAAAAAAAAAAAAAAAAIoAACKgKioCgAAAvH9aZ4/rSzjNAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGbQXU0GdUAAAAAAAAAAAABAVAAAAAFAAAAAAAAAAAAAAAAAABDQFTTQUTTQVDQFQ0AVAFABqKk8VqMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFBKgMqAAAAAAAAAAAgKgAAAAAACgAAAAAAAAmmgoiA0moAumoAqAAAAAAAAAAAAAAAAACm36igvanZAMa7f4vaMC6Y3s+q5hqY6Dnt+r2ppjYz2XYqYoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACVWal4ACKAAAAAgKIAqAAAAAAAKAAAAAmgoiA1qagCoAAKCCgIKAgoCCgAAAAAAAAAAAAAAAAAAAAAAAAAAAABt+gC9l7RkNMb2K5m1dTHQY7VrtDTFDRUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEqlKMiDKqgAAAAAAAAAACgAAJoKIAaACCgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAC7UAa7LsYDUx0HPWuy6Y0JsVUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASxltmxLFQBAAFAAAAANAE0A0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABdQBrsuysBqY6DG1ey6Y0AqAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJYjQmLrA1jKAGoKqaAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAqAAoIKgAoCCgCKAgoCCoAKAgKCCoACggqACgICggoCCgIAAKgAKCCgI1rKg1squa7V1MbE2KqAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAamgompqbBoZ2hq40awGmNbDWRNMa1NQNoum1A0XaIAogAAKAAAAAApqAi7TUDRrTWQ2mNbF2MC6Y2MLtNMaGdq6amKJsVQAAAAAAAAAAAAAAAAAAAABm8vgNM3l8ZE1cW21ARQAAAAAAAAAAAAAAAAAAAAAAAAAAUBAUEFARUUAAAAAABFAAAEUAAAAAAAAAAAAAAAAAAAAAABFABFAAAAAEUAAAAAAAEAF1AGuzTmLqY6DHZqWVdTFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABNBRNTU0aNZDVxdNQTaG0AAAAAEFAQAAAAAAAAAUAAAAAAAAAAAAAAAAAAAAAAAAXagDWmxkNTGxg2rpjYz2XYamKJs+qoAAAACbE7A0MbUTVxrtE7VBNXAAAAAAAAAAAAAAAAAAAAAAAFBAUBFARUUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABFQAAAAAAAAAAFlsallYDTHQYlsallXUxQFQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABNBRnRNXF1NBNAAAAAAAAAAAAAAAABFAQUBAAAAAAABQAAAAAAAAAAAAAAAAAAAAABFQAAAAAAAAF2/TtUAXtU3QAAAAAAAAAAAAAAAAAAAAAAABQQFAAAAAAAAAAAAAAABQQUEQUARQAAAAAAAAEFAEUBBQEFQAUBABQAAAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAABZbGpZWA1MdBmVppAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAE0FGdE1cXU0E0AAAAAAAAAAAAAAAAAAAAAAAAAAQVAAAAAAAABQAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQAAAAAAAAAAAAAURAUBFAAAAFAAAAAAAAAAFQAAAAAAEAAAAAAAABFARQBABQAAAAAAAAAAAAAAEAAAAAAAAAUAEUBBQEUAAAAAAAal+qwS4upjYm6qoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlBU1BnVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEUBAAAAAAABQAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAFQBUUAAAAAAAAAAAAAAQVFAEAUEBRAFEAUQBRAFQAUQBRAFBAUQBRAFEAUQBUAFEAFQBQQFEUBFQBUUVAAAAAAAAAAAQAAAAAAAABQAAAAAAAAAAAAAAAAAWX6gDYxLjbTIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzWkqUQBFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEVAAAAAABQAAAAAAAAAAAAAAAAABFAQAAAAAAAAAAAAAAAAAAAAAAAAABUUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAVFBUUBAAAAAAAAAAAAAAAADcAGpdVhqXVlTFAVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGcGkxMXUFxEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABFQAAAAUAAAAAAAAAAAAAAAAAAABBQEAAAAAAAAAAAAAAAAAAAAAABQRQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABFAAAAAAAAAAAAAAAAAAAAAAAAAAAAABFQAAAAAFAAARQEVFBQAQUAAAAAAARQEAAAAAAABBUBuXVc25dWVKoCoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAyNJiYqAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIKAgqAAAACgAAAAAAAAAAAAAAAAAIKAIoCAAAAAAAAAAAAAAAAAAAAKigIoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAAACgAAAAAAigAqAKAACAKgCiLgiDWQyGGsi58QUAAAAAAQAF8QB0GeN/GmmQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABMUBMRoTDWRpMMXUDBAAAAAAAAAAAAAAAAAAAAAAAAAAABAVAAFQAAAAUAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAFQBUVAUAARQAAAAAAAAAAAAAAAAAAAAAAAAAAAARQABAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABFQAFAFBEFAQVBQAAFBEVAUABUAAAEFgNT+Axyuf9VGtNn1zAdSzf+sceX5WwZC+iKAAAAgAAADo5tcfFiVoBUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZwaSxLFQBAAAAAAAAAAAAAAAAAAAAAAAAAAAQAABQAQAFAAAAAAAAAAAAAAAAEUBAAAAAAAAAAAAAAAAAAAAUAARQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQFAAEUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAVGgAFQAAAAAQABURUBQAAAEVAGp4ysBXO+10c+U/SIDI0iz2f9dnLjNv/AB1RUqLUSgAKAgAAAAC8fUa4kK0A0yAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJigJhiiZBnBoMXWRcTEwAAAAAAAAAAAAAAAAAAEUAAARUAAFAAAAAAAAAAAAAAAAAAEUBBUAAAAAAAAAAAAAAAAAAAABQABFAAAAAAAAAAAAAAAAAAAAAAAAAAABAUAAAEUAAAAAAAAAAAAAAAAAAAAAAAAAAAAABUBAAGkUABUAAAEAAAAEAFAUEAARUAIANISqDHU6/62G1CRUTQABQABAAAAAAa4sukWJQBUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASxGmaligCAAAAAAAAAAAAAAAAAigIKAgqAACgAAAAAAAAAAAAAAAAAIKgAAALJoILZiAAAAAAAAAAAAAAAqAAoACKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAigAAAigAgKAAAAAAAAAAAAAAAAAAACAAqsqCgKgAgAAAAAAgAoqKCCgIACCgIKgG1dqKCKAAACAAAAAAADUjRP4NMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACYoDI0zYzYoAAAAAAAAAAAAAAAACAAAAAAAACgAAAAAAAAAAAAAAACKANxmNLEozZ8aFRzHTNYsZxrUAAAAAAAAAAAAABUABUUBABQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFQAAAABFAAAAFBAAAAVAAVABFQBUUFAEAAAAAAAAQAVQAAAEVAAAAAAAAAEAAAAXDAQABuTEkaWJQBUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZsGkxMXUFwxMogAAAAAAAAAAAAAAACAAAAAAAKAAAAAAAAAAAAAAijUBQGmQAAAEslZssbExdcxq8fjPiKAAAAAAAAAAAAAAAAoIAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAqAAqAAACKgCoAqooAAgAAAKAgAACoAqAAAAAAAAAAgAAAAAAALJpJrayJaAKgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACVGjEsGQEUAAAAAAAAABBQAAEAAAFAAAAAAAAAAAAAAAAWNJFWMgCgAAAAAAADN4/GXRm/1KsZFRFAAAAAAAAAAAAAAUQAVFARUBQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFQAABUAAAAAAFBAAQAFEUFEAVAAAAAAAAAAAAAAAAEAAAAAAAAAFk1ZPrSyJoAqAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACYoDI0mM4uoGGAAAAAAAAAAgAAAAAAoAAAAAAAAAAAAsRsiUAaQAAAAAAAANS3GUtUARQABFAQVAAAAAAAAAAAAAAAAAURQRUUAEBQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEVAAAURQAAAAAAAAAAAABAAAAAAAAAAFk0EbkJMVcTQBUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASggDKgAAAAACKAAgAAoAAAAAAAAAAAACwFkUGmQAAAAAAABLcVlLRAEaAAAAAAAAEUBBUAAAAAAAAAAAAAAAAAABRABUAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEFQAAFEAUAAQBUAAAAAAAAAAAAAAakaXE1mT60CoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMrUSrABAAAAAAAABAUBFQAAUAAAAAAAAAAahIqxKAKgAAAAAACUEqAyoAKAAAAAAAAAAAAIoCCoAAAAAAAAAAAAAAAAAAAAAqAAAKIAogCiAKIoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIKgAAAAAAAAAAAAAAAAAslakkMTWZK1JIo1iaAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlRajN6oAAAAAAAAigAIACggAoAAAAAAAAqNQiKA0gAAAAAAAAyUZqoAAAAAAAKAAAAAAAAAAAAAAYmWNRpcTXMbyM9amLqAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKgCoAKIAKgCiAKIAogCiAKIAoICiAKIAogCggKIAogAAAAAAAAAAAC5QQa6tLiazOP1cxRUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGWhKMgIoAAAAAAAAgoCKgAAAAoAAAAACxoGoyAAAAAAAAAlBAGVAAAAEUBBUAAAAFAAAAAAAAAAanig0yAAJkUBjqmWOgmLrmN5E6mLrIuVEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAXKvUwZG8iriaxlXq0GGpkUFQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASqylWACAAAAAAAAAACAoIAAAKAAAANRGliUAVAAAAAAAABmtM31KQARQAAAAAAAEFQAAAAUAAAAAABZ6DQDTIAAAAAAAAADPWJ1rYYuueUdEyJhrA11idamLqBl+AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACyajXH9IVcig0yAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAVlajNWAAAAAAAAAACKAAgAqAAAACgLBFig0gAAAAAAAAAAlVKlEARQAAAAAAAAABFAQAUAAAAAAWIsJ1GgGkAAAAAAAAAAAAAAAAAATrE6/60BrHWpldEtTF1gURUAwAAAAAQBRFAAAAAAAAAAAAAAy/KALl+HWgg11/wBOsMNZG8i5FxNc1y/Gww1nqdY0GGpk+F/kVnkDICKAANcf1lrj6QrQDTIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACVFqM3qgAAAAAAAAAAAIoAIAAAAAo3GY0sSgCoAAAAAAAAAAAAliNJYlioAgAAAAAAAAAAgqAACgAAADUZahEqgNIAAAAAAAAAAAAAAAAAAAloFrIMqACgAAAAACKgAKCAAAAAAAAE9gs9gNZPkUGmQAAAAAAAAAAABi+tsVKsQBFAAGuPrLU9IVoBpkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABmgMqAAAAAAAAAAAAAgCiAAAKjUIKA0gAAAAAAAAAAAAAAABjLQmDIuIigAAAAAAAAAIKgAAoAA1PGW1iUAVAAAAAAAAAAAAAAAAACglrIM1QAUAAAAAAABFAEFQAVAAAAAAAFnqNcSFaAaZAAAAAAAAAAAAGGr4ylWIKIqCgIs9RZ6DYDTIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADIDKgAAAAAAAAAAAAACAACgsUGkAAAAAAAAAAAAAAAAAAAAAAZwaTExUAQAAAAAAEUBAAABRtmetLEoAqAAAAAAAAAAAAAAAADJajNqgAoAAAAAAAAAAAAigICggAAAAADXFlueESqA0gAAAAAAAAAAACXxlq+Ms1YACgABPQBsSf1WmQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGQGVAAAAAAAAAAAAAAAARqJGlhQBUAAAAAAAAAAAAAAAAAAAAAAAATEaEsGQEUAAAAABBUAAFaipFajIAAAAAAAAAAAAAAAAzatRKsQVEAAUAAAAAAAAAAAAAARUAAAAAAAdGJ62sSgCoAAAAAAAAAAAAlZarLN6sABQAAAFjTDUWJVAVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAol8BAGVAAAAAAAAAAAAAAAWEFAaQAAAAAAAAAAAAAAAAAAAAAAAAAAAAZaSpYIAigAAACKgCxGoQUBpAAAAAAAAAAAAAAAAEqNJiWKgCCCoAAKAAAAAAAAAAAAAAgqAAAAA1xaSeK1GaAAAAAAAAAAAAAAlZarLN6sABQAAABZ6hAbAaZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEqpSiAMqAAAAAAAAAAAAAARoFiACgAAAAAAAAAAAAAAAAAAAAAAAAAAAAADNFqM1QAAAAACNEGogAAAAAAAAAAAAAAAAAAlVmpQARQAEFQAAUAAAAAAAAAAAAABAAFRqeg0A0yAAAAAAAAAAAAAAlZarLN6sABQAAABYjUIigNIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJVZqUAEUAAAAAAAAAAAAWJGlhQBUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGWkqVYgCAAAQahAAaQAAAAAAAAAAAAAAAAAAZrSVKIAigACKAgAoAAAAAAAAAAAAAAioA3PGY2sSgCoAAAAAAAAAAAAAAl8Rqss1YgoCCgIKASNA0gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzWmUqwAQAAAAAAAAAAAWAoDSAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAM2DTOJYoBiBGgaiAAAAAAAAAAAAAAAAAAAAAAMgMqAAAAgAAAoAAAAAAAAAAAAgA1xaINMgAAAAAAAAAAAAAAADLTKVYAIAGANAsiACgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACVFqM1QAAAAAAAAAAACNAsQAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZoX0ZUAAAARUAAFAAAAAAAAAAAAFiNTwiVQGkAAAAAAAAAAAAAAAAGa0JRkXIpi6mKCoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlBAGVAAAAAAAAAAFiRpYACoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzRajNUAAAAABAAABQAAAAAAAAACRtJFWM0AUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEqs1KACKAAAAAAAAAsIKA0gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAy0ylWACAAAACCoAAKAAAAAAAALIjU/hEqgNIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMrUSrABAAAAAAAAgLIoNIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMrTEqoAgAAAAIqAACgAAAAAAALGgajIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADNAZUAAAAAAAAaILIgAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlRplKsAEAABFQAAUAAAAAAWT9Sf1tYlAFQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASqzUoAIoAAAAAAshIqyAAqAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADLTKVYAIAACKgAAoAAAACyAsmKDTIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACVCjNUAAAAAAWRJGlkABUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZoUZUAARUAAFAAAAG0kVYlAFQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABKCAMqAAAAEhI0sgAKgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACUEAZUAARUAAFAAFiNwiUAaQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZWolWACAAAEjRIADSAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADNaZqUgAigACKgAAoCyCLIoNIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAVlpMSxUDKuJgi4ouGgCoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAlBAGVAAEVAAWQCRoGkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEqgMi2IyoAAgsgEjQNIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMtMpVgC4gkjQNIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//Z';
$body->personalizations[0]->attachments[0]->name = 'fish.jpg';

$body->personalizations[0]->attachments[1] = new Models\Attachments;
$body->personalizations[0]->attachments[1]->content = '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';
$body->personalizations[0]->attachments[1]->name = 'ipad.png';

$body->personalizations[0]->attachments[2] = new Models\Attachments;
$body->personalizations[0]->attachments[2]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[0]->attachments[2]->name = 'zip2.zip';

$body->personalizations[0]->attachments[3] = new Models\Attachments;
$body->personalizations[0]->attachments[3]->content = 'dGVzdCB0ZXN0DQp0ZXN0IHRlc3Q=';
$body->personalizations[0]->attachments[3]->name = 'tesxt3.txt';

$body->personalizations[0]->attachments[4] = new Models\Attachments;
$body->personalizations[0]->attachments[4]->content = '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';
$body->personalizations[0]->attachments[4]->name = 'html1.html';

$body->personalizations[0]->to = array();

$body->personalizations[0]->to[0] = new Models\EmailStruct;
$body->personalizations[0]->to[0]->name = 'random';
$body->personalizations[0]->to[0]->email = 'random@gmail.com';

$body->personalizations[0]->cc = array();

$body->personalizations[0]->cc[0] = new Models\EmailStruct;
$body->personalizations[0]->cc[0]->email = 'random@gmail.com';

$body->personalizations[0]->cc[1] = new Models\EmailStruct;
$body->personalizations[0]->cc[1]->email = 'random@gmail.com';

$body->personalizations[0]->cc[2] = new Models\EmailStruct;
$body->personalizations[0]->cc[2]->email = 'random@yahoo.com';

$body->personalizations[0]->cc[3] = new Models\EmailStruct;
$body->personalizations[0]->cc[3]->email = 'random@gmail.com';

$body->personalizations[0]->bcc = array();

$body->personalizations[0]->bcc[0] = new Models\EmailStruct;
$body->personalizations[0]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[0]->tokenTo = '{"tokenTo1_key": "tokenTo1_value","tokenTo2_key": "tokenTo2_value"}';
$body->personalizations[0]->tokenCc = '{"tokencc1_key": "tokencc1_value","tokencc2_key": "tokencc2_value"}';
$body->personalizations[0]->tokenBcc = '{"tokenbcc1_key": "tokenbcc1_value","tokenbcc2_key": "tokenbcc2_value"}';

$body->personalizations[1] = new Models\Personalizations;
$body->personalizations[1]->attributes = PepipostLib\APIHelper::deserialize('{"NAME":"test2","SURNAME":"check2","PROFESSION":"QA2","AREA":"West","POST":6789}');
$body->personalizations[1]->headers = PepipostLib\APIHelper::deserialize('{"header2_key":"header2_value"}');
$body->personalizations[1]->attachments = array();

$body->personalizations[1]->attachments[0] = new Models\Attachments;
$body->personalizations[1]->attachments[0]->content = 'UEsDBBQAAAAIANG0q1CUKHpVmgIAAJsEAAAJAAAAdGV4dDEudHh0ZVRNb9NAEL1b8n8Y9RKQiJs4SdPkghAq0AuqRPmQEKo260m87dq77I5JA+p/59nGhNJEsnfezLyZfTOJboKl8Ze3F9c0iqJ2fJZ59sa7KJl21XqVTyanA7Ic5xPYi9ObyCro8qUPLHIY0fgdjV67WriW8fXB85qU99ZoJcbVp7fR1YgpaJQmv9KEiE6+NxwOJ+veaoGNc3aw/0BVE+Vk/bWFjp+/Ecc44VANqf/7tDXoyRQn67N8Olk+iXkYkKfmN5wHsH8+oP80uXaiLGkVOa5pNlukyZWKkYs1TafnafJGGQsjn6fJeyckHKXzzQF80M5zQa6RNc1X9OxzMALNSEXyHOjV1SV9WlAsmSXLamSrvQpMbkvaWRfwLJi2zlq3B42p+9DnaXJxr21TABOuvFXCLVffY5r0X7UVlAhNXZt6R1EH49FdieofL6nxBZIQG13FYiqO1E7I4F2YCMZDTzLNMFhDd3ygStXIcQGePKPphDgEtIjUqHbIU2AHUZrMsgEkUxCySAIOFTYEnaTJPKPCVQq3+aGsKbqVSZNFRtvgqqxWFROk+LfeWUaBvT3ciCPn23hl02SZtSLG1jA/O5ZOoWZzy1rausP5SNWiICddqqB0q481lZE0Oc8GJdum+8bIBRB2x063/sJpsoImlSfdr3/n6oBSKtta3QHSTRBngeDnEduRKhFdVkiBD7q6vrctqsATzKZB7Vi6prC04U5y1G74Ue1pjkZdL9JRieksw129D5AdUDuKHdcclO0pEDGHWKpm241zzxsqnbsDvuikdUHaJYFICtqwhgOab4y1gGFAavxVxBeofcc1AOiF7TNaVLuXHsgqw5v2pRG2JkqXl0/QF/iKxmKmfC+0zKkM8dHgc2jRL9tvUEsDBAoAAAAAANGCqlB2+YbAFAAAABQAAAAJAAAAdGV4dDIudHh0dGVzdCB0ZXN0DQp0ZXN0IHRlc3RQSwECPwAUAAAACADRtKtQlCh6VZoCAACbBAAACQAkAAAAAAAAACAAAAAAAAAAdGV4dDEudHh0CgAgAAAAAAABABgAtvEizbYn1gHCx96pQSnWAVY3x+i4JtYBUEsBAj8ACgAAAAAA0YKqUHb5hsAUAAAAFAAAAAkAJAAAAAAAAAAgAAAAwQIAAHRleHQyLnR4dAoAIAAAAAAAAQAYADM/RRy5JtYBwsfeqUEp1gGLTzscuSbWAVBLBQYAAAAAAgACALYAAAD8AgAAAAA=';
$body->personalizations[1]->attachments[0]->name = 'zip2.zip';

$body->personalizations[1]->to = array();

$body->personalizations[1]->to[0] = new Models\EmailStruct;
$body->personalizations[1]->to[0]->name = 'random';
$body->personalizations[1]->to[0]->email = 'random@yahoo.com';

$body->personalizations[1]->cc = array();

$body->personalizations[1]->cc[0] = new Models\EmailStruct;
$body->personalizations[1]->cc[0]->email = 'random@outlook.com';

$body->personalizations[1]->cc[1] = new Models\EmailStruct;
$body->personalizations[1]->cc[1]->email = 'testartstar@outlook.com';

$body->personalizations[1]->cc[2] = new Models\EmailStruct;
$body->personalizations[1]->cc[2]->email = 'random@rediffmail.com';

$body->personalizations[1]->cc[3] = new Models\EmailStruct;
$body->personalizations[1]->cc[3]->email = 'random@gmail.com';

$body->personalizations[1]->bcc = array();

$body->personalizations[1]->bcc[0] = new Models\EmailStruct;
$body->personalizations[1]->bcc[0]->email = 'random@gmail.com';

$body->personalizations[1]->tokenTo = '{"tokenTo3_key": "tokenTo3_value","tokenTo4_key": "tokenTo4_value"}';
$body->personalizations[1]->tokenCc = '{"tokencc5_key": "tokencc5_value","tokencc6_key": "tokencc6_value"}';
$body->personalizations[1]->tokenBcc = '{"tokenbcc7_key": "tokenbcc7_value","tokenbcc8_key": "tokenbcc8_value"}';

$body->settings = new Models\Settings;
$body->settings->footer = true;
$body->settings->clickTrack = true;
$body->settings->openTrack = true;
$body->settings->unsubscribeTrack = true;
$body->tags = array('checkbigpayload');
$body->schedule = 1589870850;
$body->bcc = array();

$body->bcc[0] = new Models\EmailStruct;
$body->bcc[0]->email = 'random@gmail.com';


try {
    $result = $mailSendController->createGeneratethemailsendrequest($body);
    var_dump($result);
} catch (PepipostLib\APIException $e) {
    echo 'Caught APIException: ',  $e->getMessage(), "\n"; 
}
```